﻿using StokYonetimSistemi.Business;
using System;
using System.Linq;
using System.Windows.Forms;

namespace StokYonetimSistemi.WinFormsUI
{
    public partial class frmStokCikis : Form
    {
        private readonly UrunManager _urunManager = new UrunManager();
        private readonly StokManager _stokManager = new StokManager();

        public frmStokCikis()
        {
            InitializeComponent();
        }

        private void frmStokCikis_Load(object sender, EventArgs e)
        {
            UrunleriListele();
            // Başlangıçta çıkış kontrollerini pasif yap, ürün seçilince aktif olacak.
            CikisKontrolleriniAyarla(false);
        }

        private void UrunleriListele(string aramaMetni = null)
        {
            var urunler = _urunManager.TumUrunleriGetir();

            if (!string.IsNullOrEmpty(aramaMetni))
            {
                urunler = urunler.Where(u => u.Ad.ToLower().Contains(aramaMetni.ToLower()) ||
                                             (u.Barkod != null && u.Barkod.Contains(aramaMetni))).ToList();
            }

            dgvUrunler.DataSource = urunler;
            // İhtiyaç olmayan kolonları gizleyelim
            dgvUrunler.Columns["Kategori"].Visible = false;
            dgvUrunler.Columns["StokHareketleri"].Visible = false;
        }

        private void txtUrunAra_TextChanged(object sender, EventArgs e)
        {
            UrunleriListele(txtUrunAra.Text);
        }

        private void dgvUrunler_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (dgvUrunler.CurrentRow != null)
            {
                lblSeciliUrun.Text = dgvUrunler.CurrentRow.Cells["Ad"].Value.ToString();
                CikisKontrolleriniAyarla(true);
            }
        }

        private void btnStokCikis_Click(object sender, EventArgs e)
        {
            if (dgvUrunler.CurrentRow == null)
            {
                MessageBox.Show("Lütfen stok çıkışı yapılacak bir ürün seçin!", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            try
            {
                int urunId = (int)dgvUrunler.CurrentRow.Cells["Id"].Value;
                int miktar = (int)nudMiktar.Value;

                // NOT: Gerçek bir uygulamada, giriş yapan kullanıcının ID'si
                // login işleminden sonra saklanır ve burada kullanılır.
                // Biz şimdilik 'admin' kullanıcısının ID'si olan 1'i varsayıyoruz.
                int kullaniciId = 1;

                // Yeni yazdığımız StokCikisiYap metodunu çağırıyoruz.
                _stokManager.StokCikisiYap(urunId, miktar, kullaniciId);

                MessageBox.Show("Stok çıkışı başarıyla yapıldı!", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);

                // İşlem sonrası listeyi yenile ve formu temizle
                UrunleriListele(txtUrunAra.Text);
                FormuTemizle();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Stok çıkışı sırasında bir hata oluştu:\n" + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void CikisKontrolleriniAyarla(bool aktifMi)
        {
            nudMiktar.Enabled = aktifMi;
            btnStokCikis.Enabled = aktifMi;
        }

        private void FormuTemizle()
        {
            lblSeciliUrun.Text = "-";
            nudMiktar.Value = 1;
            dgvUrunler.ClearSelection();
            CikisKontrolleriniAyarla(false);
        }
    }
}